//  catalog.h  -  recursive directory scanner sample code
//
//  This is a part of the MetaKit library.
//  Copyright (c) 1996 Meta Four Software.
//  All rights reserved.
/////////////////////////////////////////////////////////////////////////////

    // The following properties are used in this code
extern c4_ViewProp      pFiles;
extern c4_IntProp       pParent, pSize, pDate;
extern c4_StringProp    pName;

    // Scan a directory tree and return a corresponding structure for it.
    // The data structure of the object returned by this routine is:
    //      [parent:i, name:s, files [name:s, size:i, date:i]]
extern c4_View fScanDirectories(const char* path_);

    // Reconstruct the full path name from a subdirectory index in the tree
extern c4_String fFullPath(c4_View& dirs_, int dirNum_);

/////////////////////////////////////////////////////////////////////////////

